IF EXISTS(SELECT * 
		FROM SYS.SYSOBJECTS 
		WHERE NAME ='P_EST_PROD_CPL_ACERTO_CUSTO_TRIB' AND TYPE=N'P')
BEGIN
	DROP PROCEDURE P_EST_PROD_CPL_ACERTO_CUSTO_TRIB
END
GO

--P_EST_PROD_CPL_ACERTO_CUSTO_TRIB 506
CREATE PROCEDURE  P_EST_PROD_CPL_ACERTO_CUSTO_TRIB (@CD_FILIAL INT)
AS
--DECLARE @CD_FILIAL INT=506
/***********************************************************************************************************/

set nocount on;


	IF  OBJECT_ID('TEMPDB.DBO.#TblCustoAcerto') IS NOT NULL
	BEGIN
		DROP TABLE #TblCustoAcerto
	END 

	CREATE TABLE #TblCustoAcerto(CD_EMP		INT
								,CD_FILIAL	INT
								,CD_PROD	INT
								,DT_AJUSTE	DATE
								,CD_USU		INT
								,VlrCustoMedio	MONEY
								,PERC_ICMS MONEY
								,ICMS Tinyint
								,SUBS_TRIB Tinyint 
								,CD_TRIB	INT
								,_NF_VlrCustoMd Money
								,_NF_VlrCusto   Money
								,_NF_CdTrib		Money
								, VlrCustoAjustar money
								, Atualiza	tinyint
								, TP_AJUSTE tinyint
								)

/***********************************************************************************************************/
	Print 'Capturando os produtos para acerto - Lj ' + convert(varchar,@CD_FILIAL) + ' - Time ' +convert(Varchar, getdate(),108);

	INSERT INTO #TblCustoAcerto
	SELECT --TOP 20 
		   a.CD_EMP
		 , a.CD_FILIAL
		 , a.CD_PROD
		 , a.DT_MOV
		 , a.CD_USU
		 , ISNULL(DBO.F_VLR_CUSTO_EST_FECHA_PROC_MOV(A.CD_EMP, A.CD_FILIAL, A.CD_PROD, A.DT_MOV, 0), 0) VlrCustoMedio
		 , b.PERC_ICMS
		 , b.ICMS
		 , b.SUBS_TRIB	 
		 , b.CD_TRIB
		 , 0 _NF_VlrCustoMd
		 , 0 _NF_VlrCusto
		 , 0 _NF_CdTrib
		 , 0 VlrCustoAjustar
		 , 0 Atualiza
		 , A.TP_AJUSTE
	FROM 
		 EST_PROD_CPL_ACERTO_CUSTO_PENDENTE a
		 JOIN est_prod_cpl c ON A.CD_EMP = C.CD_EMP
								AND A.CD_FILIAL = C.CD_FILIAL
								AND A.CD_PROD = C.CD_PROD
		 JOIN prc_filial_pg_forn f ON a.cd_emp = f.cd_emp
									  AND a.cd_filial = f.cd_filial
		 CROSS APPLY UFD_EST_PROD_TRIB(a.cd_emp, a.cd_filial, 4, f.cd_forn, a.CD_PROD, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0) B
	WHERE	 C.CD_EMP = 1
		 AND A.CD_FILIAL= @CD_FILIAL 
		 AND LIBERADO = 1
		 AND C.QT_EST> 0 ;

-------------------------------------------------------------------------------------------------------------------------------------	
	Print 'Captura a ultima entrada do produto - Lj ' + convert(varchar,@CD_FILIAL) + ' - Time ' +convert(Varchar, getdate(),108);

	;With UltEnt AS(SELECT  
				 i.cd_emp
				,i.cd_filial
				,i.cd_prod
				,max(i.dt_ent) dt_ent
			From 
				est_nf_ent e
				JOIN est_nf_ent_IT I ON 
				E.CD_EMP    = I.CD_EMP AND
				E.CD_FILIAL = I.CD_FILIAL AND
				E.CD_NF		= I.CD_NF AND
				E.DT_ENT	= I.DT_ENT
				JOIN #TblCustoAcerto A ON 
				i.cd_emp	= a.cd_emp and
				i.cd_filial = a.cd_filial and
				i.cd_prod	= a.cd_prod 
				and i.dt_ent <= a.dt_ajuste
				join glb_mov_op o on
				e.cd_nt_mov = o.CD_MOV_OP
			where
				i.cd_emp=1
				and o.TP_MOV_OP_TRANSA	=0
				and o.TP_MOV			=0
				and o.DEST_ORIG			=1
			group by  
				i.cd_emp,i.cd_filial,i.cd_prod),
		UltEntProd as (select 
				 i.cd_emp
				,i.cd_filial
				,Max(I.CD_NF) cd_nf
				,i.cd_prod
			From 
				est_nf_ent e
				JOIN est_nf_ent_IT I ON 
				E.CD_EMP    = I.CD_EMP AND
				E.CD_FILIAL = I.CD_FILIAL AND
				E.CD_NF		= I.CD_NF AND
				E.DT_ENT	= I.DT_ENT
				JOIN UltEnt A ON 
				i.cd_emp	= a.cd_emp and
				i.cd_filial = a.cd_filial and
				i.cd_prod	= a.cd_prod  
				and i.dt_ent = a.dt_ent
				join glb_mov_op o on
				e.cd_nt_mov = o.CD_MOV_OP
		where
			i.CD_EMP=1
				and o.TP_MOV_OP_TRANSA	=0
				and o.TP_MOV			=0
				and o.DEST_ORIG			=1 
			group by  
				i.cd_emp,i.cd_filial,i.cd_prod)	
			Update T
			set  _NF_VlrCustoMd=I.VLR_CUSTO_MD
				,_NF_VlrCusto  =I.VLR_PRC_CUSTO
				,_NF_CdTrib	   =I.CD_TRIB
			from 
				UltEntProd a
				JOIN est_nf_ent_it I ON 
				a.cd_emp    = i.cd_emp and
				a.cd_filial = i.cd_filial and
				a.cd_nf		= i.cd_nf and
				a.cd_prod		= i.cd_prod  
				join #TblCustoAcerto t on
				a.cd_emp    = T.cd_emp and
				a.cd_filial = T.cd_filial and
				a.cd_prod	= T.cd_prod ;

	
/*******************************************************************************************************************************************************/		
		Print 'Atualiza o valor de custo a ajustar - Lj ' + convert(varchar,@CD_FILIAL) + ' - Time ' +convert(Varchar, getdate(),108);
	 
		Update 
			#TblCustoAcerto
		set
			 VlrCustoAjustar=  VlrCustoMedio + (Case when Icms =1 then -1
				                    else 1 End * (VlrCustoMedio * (PERC_ICMS/100.00)))  
			,Atualiza=1
		where CD_TRIB <>_NF_CdTrib;
			
				
/*******************************************************************************************************************************************************/
	DECLARE @ErrorMessage NVARCHAR(4000);  
	DECLARE @ErrorSeverity INT;  
	DECLARE @ErrorState INT;  
	
	Print 'Inserindo o acerto de custo - Lj ' + convert(varchar,@CD_FILIAL) + ' - Time ' +convert(Varchar, getdate(),108);
	 
	Begin Try
		DECLARE @CD_CTR INT;  

		update #tblcustoacerto set atualiza=0 where atualiza=1 and vlrcustoajustar<=0;

		set @CD_CTR  = ISNULL((Select Max(CD_CTR) from  EST_PROD_CPL_ACERTO_CUSTO),0)+1;
		delete from a
		From 
			#TblCustoAcerto	 T
			JOIN est_prod_cpl_acerto_custo  A ON 
			T.CD_EMP	  = A.CD_EMP		AND
			T.CD_FILIAL   = A.CD_FILIAL		AND
			T.CD_PROD	  = A.CD_PROD		AND
			T.DT_AJUSTE	  = A.DT_MOV
		WHERE
			T.ATUALIZA=1			
			AND A.TP_AJUSTE=5
			AND	A.CD_EMP IS NULL

		Insert Into est_prod_cpl_acerto_custo (CD_CTR, CD_EMP, CD_FILIAL, CD_PROD, VLR_CUSTO_ACERTO, CD_USU, 
						DT_MOV, DT_CAD, TP_AJUSTE, QT_AJUSTE, VLR_AJUSTE_TRANSF)
		select  
			 Row_Number() Over(Order by T.CD_EMP, T.CD_PROD) + @CD_CTR
			, T.CD_EMP
			, T.CD_FILIAL
			, T.CD_PROD
			, T.VlrCustoAjustar
			, T.CD_USU
			, T.DT_AJUSTE
			, GETDATE() DT_CAD
			, T.TP_AJUSTE
			, 0 QT_AJUSTE
			, NULL VLR_AJUSTE_TRANSF
		From 
			#TblCustoAcerto	 T
			LEFT JOIN est_prod_cpl_acerto_custo  A ON 
			T.CD_EMP	  = A.CD_EMP		AND
			T.CD_FILIAL   = A.CD_FILIAL		AND
			T.CD_PROD	  = A.CD_PROD		AND
			T.DT_AJUSTE	  = A.DT_MOV
		WHERE
			T.ATUALIZA=1			
			AND	A.CD_EMP IS NULL;

		--Remove da pendencia
		DELETE FROM A
		From 
			#TblCustoAcerto	 T
			JOIN EST_PROD_CPL_ACERTO_CUSTO_PENDENTE  A ON 
			T.CD_EMP	  = A.CD_EMP		AND
			T.CD_FILIAL   = A.CD_FILIAL		AND
			T.CD_PROD	  = A.CD_PROD		AND
			T.DT_AJUSTE	  = A.DT_MOV 

	end try
	begin catch
	 
		SELECT   
			@ErrorMessage = N'Falha ao inserir acerto de custo. - ' + ERROR_MESSAGE(),  
			@ErrorSeverity = ERROR_SEVERITY(),  
			@ErrorState = ERROR_STATE();  
		  RAISERROR (@ErrorMessage,@ErrorSeverity,@ErrorState);   
	end catch
	 
	Print '*************************************';
	 